#include <iostream>
#include <math.h>
#include <cstdlib>
#include "global.h"
#include "comm.h"

#include "cloud.h"

Cloud::Cloud() {
	vapour = 0.0F;
	type = NONE;
	next = NULL;
}
Cloud::Cloud(char* line, cloudtype tp) {
	char* tmp;
	type = tp;
	next = NULL;
	points = -1;
	
	tmp = str_get(line);
	position.x = atof(tmp);
	delete [] tmp;
	tmp = str_get(line);
	position.y = atof(tmp);
	delete [] tmp;
	tmp = str_get(line);
	velocity.x = atof(tmp);
	delete [] tmp;
	tmp = str_get(line);
	velocity.y = atof(tmp);
	delete [] tmp;
	tmp = str_get(line);
	vapour = atof(tmp);
	delete [] tmp;

	speed = velocity.x * velocity.x + velocity.y * velocity.y;
}

void Cloud::set_next(Cloud* cl) {
	next = cl;
}
Cloud* Cloud::get_next() {
	return next;
}
float Cloud::get_vapour() {
	return vapour;
}
void Cloud::cal_points(Cloud* me) {
	pos diff, nxt_this, nxt_me;
	int dist, no_iterations, cost;

	//Finds distance to the cloud
	diff.x = position.x - me->position.x;
	diff.y = position.y - me->position.y;
	dist = sqrt(diff.x * diff.x + diff.y * diff.y);

	//Calculates time to travel<
	no_iterations = dist / PIXELPERIT;

	//Calculates where "this" is when they meet
	nxt_this.x = position.x + ((velocity.x * 0.1) * no_iterations);
	nxt_this.y = position.y + ((velocity.y * 0.1) * no_iterations);

	//Calculates vector from me, to nxt_this
	nxt_me.x = (10 * (nxt_this.x - me->position.x) / no_iterations) - me->velocity.x;
	nxt_me.y = (10 * (nxt_this.y - me->position.y) / no_iterations) - me->velocity.y;

	//Calculate cost
	cost = sqrt(nxt_me.x * nxt_me.x + nxt_me.y * nxt_me.y) * SCALE / 100;

	if(vapour < me->vapour - cost - MARGIN) points = (vapour - cost);
	else points = -1;
}
void Cloud::next_move(Comm* c, Cloud* me) {
	char buf[BUFLEN], t1[BUFLEN];
	char* recv;
	pos diff, nxt_this, nxt_me;
	int dist, no_iterations, cost;

	strcpy(buf, "WIND ");
	
	//Finds distance to the cloud
	diff.x = position.x - me->position.x;
	diff.y = position.y - me->position.y;
	dist = sqrt(diff.x * diff.x + diff.y * diff.y);

	//Calculates time to travel
	no_iterations = dist / PIXELPERIT;

	//Calculates where "this" is when they meet
	nxt_this.x = position.x + ((velocity.x * 0.1) * no_iterations);
	nxt_this.y = position.y + ((velocity.y * 0.1) * no_iterations);

	//Calculates vector from me, to nxt_this
	nxt_me.x = (10 * (nxt_this.x - me->position.x) / no_iterations) - me->velocity.x;
	nxt_me.y = (10 * (nxt_this.y - me->position.y) / no_iterations) - me->velocity.y;

	itoa(int(nxt_me.x), t1, 10);
	strcat(buf, t1); strcat(buf, " ");
	itoa(int(nxt_me.y), t1, 10);
	strcat(buf, t1); strcat(buf, "\n");

	c->s(buf);
	recv = c->r();
	
	delete [] recv;
}
int Cloud::get_points() {
	return points;
}
int Cloud::get_speed() {
	return speed;
}

//DEBUG FUNCTIONS
void Cloud::display(){
	std::cout << "Position: " << position.x << ", " << position.y << '\n'
			  << "Velocity: " << velocity.x << ", " << velocity.y << '\n'
			  << "Vapour: " << vapour << "\n"
			  << "Score: " << points << "\n\n";
}